attribute vec2 coord;
uniform mat4 mvp;

varying vec2 f_texcoord;

attribute vec4 texfactor;
varying float f_texfactor[TEX_NUM];

#define TEX_SCALE_X (0.001)
#define TEX_SCALE_Y (-TEX_SCALE_X*2.0)


void main(void)
{
	gl_Position = mvp * vec4(coord.x, coord.y, 0.0, 1.0);

	f_texcoord = vec2(coord.x*TEX_SCALE_X, coord.y*TEX_SCALE_Y);
	for(int i = 0; i < TEX_NUM; ++i)
		f_texfactor[i] = texfactor[i]/float(TEX_NUM);
}
